;----------========== Parsing (common to every scripts) ==========----------
; The script is being passed 2 parameters by mGalaxy.
; The first one contains the full path to the emulator.
; The second one contains parameters (optional) for the emulator PLUS the full path (between quotes) to the rom file.
;
; Line 13: $CmdLine is an array of size 3. $CmdLine[0] returns the total number of items in the array, $CmdLine[1] the 1st parameter, $CmdLine[2] the 2nd parameter
; Line 19: AutoIt requires that parameters sent by mGalaxy be enclosed in quotation marks.
;          As the parameters themselves contain quotation marks, these have been replaced by a distinguishing sign (%s) so as not to cause any confusion in the constitution of the command line.
;          So we now replace this distinguishing sign with quotation marks.
; Line 20: Some apps (MESS for instance, when it searchs for a system Bios) need to know the path to their 'Working Directory'. We do extract it from the emulator full path.
;
#include <MsgBoxConstants.au3>
If UBound($CmdLine) <> 3 Then
   MsgBox($MB_SYSTEMMODAL, "Script execution error", "The script was expecting to receive 2 parameters but received " & UBound($CmdLine)-1, 10)
   Exit 0
EndIf

local $app = $CmdLine[1]
local $command = StringReplace($CmdLine[2], "%s", """")
Local $workingDir = StringRegExpReplace($app, "\\[^\\]*$", "")
FileChangeDir($workingDir)
;---------------------------------------------------------------------------

hotkeyset("{esc}", "Terminate")

;load application
local $PID = Run ( '"' & $app & '" ' & $command )
;wait for window to be active
WinWaitActive("[CLASS:CdiWndClass]")
;then set it fullscreen
WinMenuSelectItem("[CLASS:CdiWndClass]", "", "&Window", "&Fullscreen")

;waiting loop
While ProcessExists ( $PID )
   Sleep(500)
WEnd

;exit
exit 0

;*************************************
;functions
Func Terminate()
   Send("!+{F4}",0)
   Exit 0
EndFunc